(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12879,        395]*)
(*NotebookOutlinePosition[     13986,        431]*)
(*  CellTagsIndexPosition[     13942,        427]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Example of RSA Public Key Cryptography"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Colin P. Williams "], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Copyright Notice"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Copyright Colin P. Williams (1997).\n\nThis Notebook is intended to be used \
in conjunction with \"Explorations in Quantum Computing\" by Colin P. \
Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), \
ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this \
Notebook freely for any non-commercial activity provided you include this \
copyright notice at the beginning of all such copies. Please send suggestions \
and bug reports to Colin P. Williams at \n        colin@solstice.jpl.nasa.gov \
     (818) 306 6512 or \n        cpw@cs.stanford.edu               (415) 728 \
2118\nFor information on \"Explorations in Quantum Computing\" check out the \
TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. \
To order call 1-800-777-4643.\n\nAll other rights reserved."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["How to use this Notebook"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This Notebook contains code that implements the RSA Public Key Cryptography \
algorithm (see \"Explorations in Quantum Computing\", Chapter 6).  You can \
use this software to explore the details of how the RSA algorithm works.  \
Note that RSA codes based on sufficiently large keys are very hard to crack \
on classical computers but would be very easy to crack on quantum computers \
(assuming anyone could build such a device).  The crux of the matter, \
concerns the difficulty of factoring the large integer n (the product of two \
large primes p and q) that is used in the RSA algorithm.  If you know the \
factors of n (i.e. p and q) you can unscramble the message easily using \
efficient classical algorithms.  However, to obtain the factors using a \
classical computer is effectively intractable (as far as is known).  By \
contrast Peter Shor discovered a fast quantum algorithm for performing the \
necessary factorization of n.  So a quantum computer renders the RSA scheme \
vulnerable to attack.  This is important because the RSA scheme is currently \
the most widely used cryptographic scheme for secure communications.  See \
Chapter 6 for complete details. \n\nPlease note that all active components of \
our implementation of the RSA cryptosystem have been deleted from this CD-ROM \
to ensure compliance with U.S. Federal Law regarding Department of Commerce \
prohibitions on the export of cryptographic software.  The examples below are \
sufficient to illustrate the general principles behind RSA Public Kep \
Cryptography but they will not permit you to generate any new examples for \
yourself. We may be able to export the active code components of the RSA \
simulator in the future subject to U.S. government approval.\n\nThe following \
commands are (or rather \"were\") available in this Notebook:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["CreatePublicKeyAndPrivateKey\nEncryptRSA\nDecryptRSA"], "Input",
  AspectRatioFixed->True],

Cell[TextData["You can use query (?) to find out how to use them."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["?CreatePublicKeyAndPrivateKey"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"CreatePublicKeyAndPrivateKey[nDigits] creates a matching public key and \
private key\n   based on an integer with roughly nDigits. These keys can then \
be used as the basis\n   for establishing secure communications over a public \
channel using the RSA\n   cryptosystem."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["?EncryptRSA"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"EncryptRSA[message, $PublicKey] creates an RSA encryption of the given \
message string\n   using the public key, $PublicKey. $PublicKey, and its \
matching private key,\n   $PrivateKey, are created using the function \
CreatePublicKeyAndPrivateKey."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["?DecryptRSA"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"DecryptRSA[cipher, $PrivateKey] decrypts the encrypted message cipher using \
the\n   private key, $PrivateKey. $PrivateKey, and its matching public key, \
$PublicKey, are\n   created using the function \
CreatePublicKeyAndPrivateKey."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"To create a public key (the pair {e,n}) and a private key (the pair {d,n}) \
based on an integer n which has roughly 20 decimal digits, do the \
following."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"SeedRandom[12345];\n{$PublicKey, $PrivateKey} = \
CreatePublicKeyAndPrivateKey[20]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Picking p: p = 6257493337\nPicking q: q = 6356046119\nHence n = p q = \
39772916239307209103\nPicking large integer d, co-prime to n: d = \
5380958597982080231\nComputing modular inverse, e, from e d = 1 mod \
(p-1)(q-1): e = 34928543677329462263\nPublic  Key is {e, n} = \
{34928543677329462263, 39772916239307209103}\nPrivate Key is {d, n} = \
{5380958597982080231, 39772916239307209103}"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{{34928543677329462263, 39772916239307209103}, 
 
  {5380958597982080231, 39772916239307209103}}\
\>", 
"\<\
{{34928543677329462263, 39772916239307209103}, 
 
  {5380958597982080231, 39772916239307209103}}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"You can use the public key you created with the CreatePublicKeyAndPrivateKey \
command to encrypt a message."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"cipherText = EncryptRSA[\"Here is a secret message!\", $PublicKey]"], "Input",\

  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{21581138220304090677, 6735419423900161318, 14656070734333860517, 
 
  37836439796525544215, 8493526611104820682, 31643097529326638584, 
 
  24188966197022276704, 9984261459086080108, 37632380013932171088, 
 
  9135466893726490912, 18587760351464133513, 19847824799197601467, 
 
  35875467339193717907}\
\>", 
"\<\
{21581138220304090677, 6735419423900161318, 14656070734333860517, 
 
  37836439796525544215, 8493526611104820682, 31643097529326638584, 
 
  24188966197022276704, 9984261459086080108, 37632380013932171088, 
 
  9135466893726490912, 18587760351464133513, 19847824799197601467, 
 
  35875467339193717907}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Upon receipt of this message, the intended recipient (who already owns the \
private key) can decrypt it using the command DecryptRSA."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["DecryptRSA[cipherText, $PrivateKey]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
\"Here is a secret message!\"\
\>", 
"\<\
Here is a secret message!\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"If you want to send a message that contains literal quotation marks, add a \
leading backslash (i.e. include \\\" instead of just \"). Also, if you want \
to wrap text onto the next line use a backslash (i.e. a single \\ alone)."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"cipherText = EncryptRSA[\"Our next book is called \\\"Ultimate Zero and \\\n \
                        One: Computing at the Edge of Nature\\\".\",\n        \
                 $PublicKey]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{28449394887351054838, 20309977873594138267, 35788942777316477877, 
 
  32706257880145368061, 21376640105731263673, 12515814310468555934, 
 
  25356465966372462285, 22419846478451609105, 10881239137646505327, 
 
  4189619288609140736, 4553858535245731476, 16716614928816581854, 
 
  21199668513993951004, 24867948928438688419, 20635667573977587502, 
 
  30338782169335759551, 7785078759135308564, 4372435421592635675, 
 
  3824945321207306966, 2018537172583222694, 15737846528428402790, 
 
  27114764752896272085, 35788942777316477877, 17660905472642105555, 
 
  29229089794268129403, 884273825642331831, 14472428233212401497, 
 
  17625133666328350954, 23912192753826421406, 30338782169335759551, 
 
  24841783216444229013, 3295900894041022436, 19782830802922313817, 
 
  32692530849560831721, 7785078759135308564, 2448528761549636596, 
 
  2935932729727566345, 30338782169335759551, 7723026894237838852, 
 
  29557638145854992825, 6935087650258942190}\
\>", 
"\<\
{28449394887351054838, 20309977873594138267, 35788942777316477877, 
 
  32706257880145368061, 21376640105731263673, 12515814310468555934, 
 
  25356465966372462285, 22419846478451609105, 10881239137646505327, 
 
  4189619288609140736, 4553858535245731476, 16716614928816581854, 
 
  21199668513993951004, 24867948928438688419, 20635667573977587502, 
 
  30338782169335759551, 7785078759135308564, 4372435421592635675, 
 
  3824945321207306966, 2018537172583222694, 15737846528428402790, 
 
  27114764752896272085, 35788942777316477877, 17660905472642105555, 
 
  29229089794268129403, 884273825642331831, 14472428233212401497, 
 
  17625133666328350954, 23912192753826421406, 30338782169335759551, 
 
  24841783216444229013, 3295900894041022436, 19782830802922313817, 
 
  32692530849560831721, 7785078759135308564, 2448528761549636596, 
 
  2935932729727566345, 30338782169335759551, 7723026894237838852, 
 
  29557638145854992825, 6935087650258942190}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["DecryptRSA[cipherText, $PrivateKey]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
\"Our next book is called \\\"Ultimate Zero and One: Computing at the \
Edge of\\
 
  Nature\\\".\"\
\>", 
"\<\
Our next book is called \"Ultimate Zero and One: Computing at the Edge \
of Nature\".\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{52, Automatic}, {30, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002n88o?mooh<<H`Ui0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@BU_l0000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 114, 3, 136, "Title",
  Evaluatable->False],
Cell[1848, 56, 99, 2, 53, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1972, 62, 112, 3, 50, "Section",
  Evaluatable->False],
Cell[2087, 67, 921, 14, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3045, 86, 101, 2, 44, "Section",
  Evaluatable->False],
Cell[3149, 90, 1904, 26, 246, "Text",
  Evaluatable->False],
Cell[5056, 118, 105, 1, 40, "Input"],
Cell[5164, 121, 124, 2, 25, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5313, 127, 82, 1, 22, "Input"],
Cell[5398, 130, 349, 6, 44, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[5784, 141, 64, 1, 22, "Input"],
Cell[5851, 144, 325, 6, 35, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[6213, 155, 64, 1, 22, "Input"],
Cell[6280, 158, 310, 6, 35, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[6627, 169, 90, 2, 33, "Subsubsection",
  Evaluatable->False],
Cell[6720, 173, 230, 5, 38, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6975, 182, 136, 3, 30, "Input"],
Cell[7114, 187, 465, 8, 71, "Print",
  Evaluatable->False],
Cell[7582, 197, 295, 11, 31, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7926, 214, 90, 2, 33, "Subsubsection",
  Evaluatable->False],
Cell[8019, 218, 183, 4, 25, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8227, 226, 122, 3, 22, "Input"],
Cell[8352, 231, 708, 24, 70, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9109, 261, 90, 2, 33, "Subsubsection",
  Evaluatable->False],
Cell[9202, 265, 209, 4, 38, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9436, 273, 88, 1, 22, "Input"],
Cell[9527, 276, 157, 7, 22, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9733, 289, 90, 2, 33, "Subsubsection",
  Evaluatable->False],
Cell[9826, 293, 306, 6, 38, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10157, 303, 241, 4, 40, "Input"],
Cell[10401, 309, 2010, 60, 184, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[12448, 374, 88, 1, 22, "Input"],
Cell[12539, 377, 288, 12, 22, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

